/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.flow;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import oracle.install.commons.flow.AbstractFlowExecutor;
import oracle.install.commons.flow.FlowException;
import oracle.install.commons.flow.FlowExecutionMode;
import oracle.install.commons.flow.FlowExecutorType;
import oracle.install.commons.flow.Route;
import oracle.install.commons.flow.State;
import oracle.install.commons.flow.TraceRoutePolicy;
import oracle.install.commons.flow.ViewManagerException;
import oracle.install.commons.flow.validation.ValidationException;
import oracle.install.commons.util.Graph;

public abstract class AbstractGraphicalFlowExecutor
extends AbstractFlowExecutor {
    public AbstractGraphicalFlowExecutor() {
        this.traceRoutePolicy = TraceRoutePolicy.ONLY_VIEW_STATES;
    }

    @Override
    protected FlowExecutionMode confirmSessionContinuation() {
        FlowExecutionMode flowExecutionMode = FlowExecutionMode.NEW;
        return flowExecutionMode;
    }

    @Override
    public void execute() {
    }

    @Override
    public FlowExecutorType getFlowExecutorType() {
        return FlowExecutorType.INTERACTIVE;
    }

    @Override
    protected void reconcileState(State state) {
    }

    @Override
    protected boolean confirmReconcileSessionContinuation() {
        return false;
    }

    @Override
    protected void loadView(final Graph<Route, State> vertex) throws FlowException, ViewManagerException {
        FutureTask<Void> loadViewTask = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractGraphicalFlowExecutor.super.loadView(vertex);
                return null;
            }
        });
        SwingUtilities.invokeLater(loadViewTask);
        try {
            loadViewTask.get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof FlowException) {
                throw (FlowException)t;
            }
            if (t instanceof ViewManagerException) {
                throw (ViewManagerException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void unloadView(final Graph<Route, State> vertex) {
        FutureTask<Void> unloadViewTask = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractGraphicalFlowExecutor.super.unloadView(vertex);
                return null;
            }
        });
        SwingUtilities.invokeLater(unloadViewTask);
        try {
            unloadViewTask.get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void processInput(final Graph<Route, State> vertex) throws FlowException, ValidationException {
        FutureTask<Void> processInputTask = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AbstractGraphicalFlowExecutor.super.processInput(vertex);
                return null;
            }
        });
        SwingUtilities.invokeLater(processInputTask);
        try {
            processInputTask.get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof FlowException) {
                throw (FlowException)t;
            }
            if (t instanceof ValidationException) {
                throw (ValidationException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

